define pacemaker::service (
  $ensure              = 'present',
  $ocf_root_path       = '/usr/lib/ocf',
  $primitive_class     = 'ocf',
  $primitive_provider  = 'fuel',
  $primitive_type      = undef,
  $prefix              = true,

  $parameters          = undef,
  $operations          = undef,
  $metadata            = undef,

  $complex_metadata    = undef,
  $complex_type        = undef,

  $use_handler         = true,
  $handler_root_path   = '/usr/local/bin',

  $ocf_script_template = undef,
  $ocf_script_file     = undef,

  $create_primitive    = true,
) {
  $service_name     = $name

  if $prefix {
    $primitive_name   = "p_${service_name}"
  } else {
    $primitive_name   = $service_name
  }

  $ocf_script_name  = "${service_name}-ocf-file"
  $ocf_handler_name = "ocf_handler_${service_name}"

  $ocf_dir_path     = "${ocf_root_path}/resource.d"
  $ocf_script_path  = "${ocf_dir_path}/${primitive_provider}/${$primitive_type}"
  $ocf_handler_path = "${handler_root_path}/${ocf_handler_name}"

  Service <| title == $service_name |> {
    provider   => 'pacemaker',
  }

  Service <| name == $service_name |> {
    provider   => 'pacemaker',
  }

  if $create_primitive {
    pcmk_resource { $primitive_name :
      ensure             => $ensure,
      primitive_class    => $primitive_class,
      primitive_type     => $primitive_type,
      primitive_provider => $primitive_provider,
      parameters         => $parameters,
      operations         => $operations,
      metadata           => $metadata,
      complex_metadata   => $complex_metadata,
      complex_type       => $complex_type,
    }
  }

  if $ocf_script_template or $ocf_script_file {
    file { $ocf_script_name :
      ensure  => $ensure,
      path    => $ocf_script_path,
      mode    => '0755',
      owner   => 'root',
      group   => 'root',
    }

    if $ocf_script_template {
      File[$ocf_script_name] {
        content => template($ocf_script_template),
      }
    } elsif $ocf_script_file {
      File[$ocf_script_name] {
        source => "puppet:///modules/${ocf_script_file}",
      }
    }

  }

  if ($primitive_class == 'ocf') and ($use_handler) {
    file { $ocf_handler_name :
      path    => $ocf_handler_path,
      ensure  => 'present',
      owner   => 'root',
      group   => 'root',
      mode    => '0700',
      content => template('pacemaker/ocf_handler.erb'),
    }
  }

  File <| title == $ocf_script_name |> -> Pcmk_resource <| title == $primitive_name |>
  File <| title == $ocf_script_name |> ~> Service[$service_name]
  Pcmk_resource <| title == $primitive_name |> -> Service[$service_name]
  File <| title == $ocf_handler_name |> -> Service[$service_name]

}
