require 'spec_helper'

describe 'collectd::plugin::redis', :type => :class do

  context ':ensure => present, default params' do
    let :facts do
      {:osfamily => 'RedHat'}
    end
    it 'Will create /etc/collectd.d/10-redis.conf' do
      should contain_file('redis.load').with({
        :ensure  => 'present',
        :path    => '/etc/collectd.d/10-redis.conf',
        :content => /\#\ Generated by Puppet\nLoadPlugin redis\n\n<Plugin redis>\n  <Node "redis">\n    Host "localhost"\n    Port "6379"\n    Timeout 2000\n  <\/Node>\n<\/Plugin>\n/,
      })
    end
  end

  context ':ensure => absent' do
    let :facts do
      {:osfamily => 'RedHat'}
    end
    let :params do
      {:ensure => 'absent'}
    end

    it 'Will not create /etc/collectd.d/10-redis.conf' do
      should contain_file('redis.load').with({
        :ensure => 'absent',
        :path   => '/etc/collectd.d/10-redis.conf',
      })
    end
  end
end
