require 'spec_helper'

describe 'collectd::plugin::zfs_arc', :type => :class do

  context ':ensure => present' do
    let :facts do
      {:osfamily => 'FreeBSD'}
    end
    it 'Will create 10-zfs_arc.conf' do
      should contain_file('zfs_arc.load').with({
        :ensure  => 'present',
        :path    => '/usr/local/etc/collectd/10-zfs_arc.conf',
        :content => /\#\ Generated by Puppet\nLoadPlugin zfs_arc\n/,
      })
    end
  end

  context ':ensure => absent' do
    let :facts do
      {:osfamily => 'FreeBSD'}
    end
    let :params do
      {:ensure => 'absent'}
    end

    it 'Will not create 10-zfs_arc.conf' do
      should contain_file('zfs_arc.load').with({
        :ensure => 'absent',
        :path   => '/usr/local/etc/collectd/10-zfs_arc.conf',
      })
    end
  end
end

